/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWStepParameterPanel
extends VWStepPropTabPanel
implements ListSelectionListener,
IVWPropertyChangeListener {
    private int m_updatingCount = 0;
    private Object m_countSync = new Object();
    private static final int COL_ACCESS = 0;
    private static final int COL_NAME = 1;
    private static final int COL_EXPRESSION = 2;
    private VWStepDefinition m_stepDefinition = null;
    private VWCompoundStepDefinition m_compoundStepDefinition = null;
    private Vector m_parameters;
    private VWTable m_parameterTable;
    private JLabel m_operationNameLabel;
    private VWParameterTableModel m_parameterTableModel;
    private DefaultTableCellRenderer m_modeRenderer;
    private DefaultTableCellRenderer m_nameRenderer;
    private DefaultTableCellRenderer m_expressionRenderer;
    private JTextArea m_promptUI;
    private Vector m_operationVector = new Vector();
    private JComboBox m_operationCombo = null;
    private ItemListener m_operationComboItemListener = null;
    private DefaultComboBoxModel m_operationComboModel = null;
    private boolean bCompoundStep = false;
    private static ImageIcon m_readOnlyIcon;
    private static ImageIcon m_writeOnlyIcon;
    private static ImageIcon m_readWriteIcon;
    private static ImageIcon m_dataFieldIcon;
    private static ImageIcon m_attachmentIcon;
    private static ImageIcon m_workflowGroupIcon;

    public VWStepParameterPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 7;
        this.preSetupLayout();
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.setUpdating();
            if (this.m_step != null) {
                VWMapNode mapNode = this.m_step.getMapNode();
                if (mapNode != null && mapNode instanceof VWCompoundStepDefinition) {
                    this.bCompoundStep = true;
                }
                if (this.bCompoundStep) {
                    this.m_compoundStepDefinition = this.m_step.getCompoundStepDefinition();
                } else {
                    this.m_stepDefinition = this.m_step.getStepDefinition();
                }
            } else {
                this.m_stepDefinition = null;
                this.m_compoundStepDefinition = null;
            }
            VWPropertyChangeNotifier.addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preSetupLayout() {
        try {
            this.setUpdating();
            if (m_readOnlyIcon == null) {
                m_readOnlyIcon = VWImageLoader.createImageIcon("read_access.gif");
            }
            if (m_writeOnlyIcon == null) {
                m_writeOnlyIcon = VWImageLoader.createImageIcon("write_access.gif");
            }
            if (m_readWriteIcon == null) {
                m_readWriteIcon = VWImageLoader.createImageIcon("readwrite_access.gif");
            }
            if (m_dataFieldIcon == null) {
                m_dataFieldIcon = VWImageLoader.createImageIcon("field.gif");
            }
            if (m_attachmentIcon == null) {
                m_attachmentIcon = VWImageLoader.createImageIcon("attachment.gif");
            }
            if (m_workflowGroupIcon == null) {
                m_workflowGroupIcon = VWImageLoader.createImageIcon("wflgroup.gif");
            }
            JLabel parametersLabel = new JLabel(VWResource.s_label.toString(VWResource.s_parameters));
            this.initParameterModel();
            JScrollPane scrollPane = new JScrollPane(this.m_parameterTable);
            this.createRenderers();
            if (this.m_parameterTable != null) {
                TableColumnModel columnModel = this.m_parameterTable.getColumnModel();
                TableColumn columnAccess = columnModel.getColumn(0);
                TableColumn columnName = columnModel.getColumn(1);
                TableColumn columnExpression = columnModel.getColumn(2);
                int width = Math.max(m_readOnlyIcon.getIconWidth(), Math.max(m_readWriteIcon.getIconWidth(), m_writeOnlyIcon.getIconWidth()));
                columnAccess.setMinWidth(width + 4);
                columnAccess.setMaxWidth(width + 4);
                columnAccess.setCellRenderer(this.m_modeRenderer);
                columnName.setCellRenderer(this.m_nameRenderer);
                columnExpression.setCellRenderer(this.m_expressionRenderer);
                this.m_parameterTable.setSelectionMode(0);
                this.m_parameterTable.getSelectionModel().addListSelectionListener(this);
            }
            JLabel promptLabel = new JLabel(VWResource.s_label.toString(VWResource.s_prompt));
            this.m_promptUI = new JTextArea();
            this.m_promptUI.setEditable(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 23;
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.createOperationPanel(), c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)parametersLabel, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.fill = 1;
            this.add((Component)scrollPane, c);
            ++c.gridy;
            c.weighty = 0.0;
            c.fill = 2;
            this.add((Component)promptLabel, c);
            ++c.gridy;
            c.weighty = 0.2;
            c.fill = 1;
            this.add((Component)new JScrollPane(this.m_promptUI), c);
        }
        finally {
            this.doneUpdating();
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
    }

    private JPanel createOperationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_operationNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_operation));
        this.m_operationComboModel = new DefaultComboBoxModel();
        this.m_operationCombo = new JComboBox(this.m_operationComboModel);
        this.m_operationComboItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VWStepParameterPanel.this.initParameterModel();
                }
            }
        };
        this.m_operationCombo.addItemListener(this.m_operationComboItemListener);
        this.m_operationCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                if (value != null && value instanceof VWInstructionDefinition) {
                    ((JLabel)component).setText(VWInstruction.ExecuteInstructionGetOperationName((VWInstructionDefinition)value));
                }
                return component;
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        panel.add((Component)this.m_operationNameLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 6, 0, 0);
        this.m_operationCombo.setPreferredSize(new Dimension(40, 20));
        panel.add((Component)this.m_operationCombo, c);
        return panel;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            block0 : switch (type) {
                case 702: {
                    if (source == this) break;
                    if (this.getSelectedStep() == null) {
                        return;
                    }
                    VWTrkStepOccurrence occurrence = this.getSelectedStepOccurrence();
                    if (occurrence == null) {
                        return;
                    }
                    String selectedOpName = occurrence.getOperationName();
                    if (selectedOpName == null) {
                        return;
                    }
                    int index = 0;
                    for (index = 0; index < this.m_operationComboModel.getSize(); ++index) {
                        String sString = null;
                        Object selectedObj = this.m_operationCombo.getItemAt(index);
                        if (selectedObj instanceof String) {
                            sString = selectedObj.toString();
                        } else if (selectedObj instanceof VWInstructionDefinition) {
                            sString = VWInstruction.ExecuteInstructionGetOperationName((VWInstructionDefinition)selectedObj);
                        }
                        if (VWStringUtils.compare(sString, selectedOpName) != 0) continue;
                        this.m_operationCombo.setSelectedIndex(index);
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getSource() == this.m_parameterTable.getSelectionModel() && this.m_promptUI != null) {
            Object obj;
            String prompt = null;
            int index = this.m_parameterTable.getSelectedRow();
            if (index >= 0 && index < this.m_parameters.size() && (obj = this.m_parameters.elementAt(index)) != null && obj instanceof VWParameterDefinition) {
                prompt = ((VWParameterDefinition)obj).getDescription();
            }
            this.m_promptUI.setText(prompt);
        }
    }

    private void createRenderers() {
        this.m_modeRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                if (component != null && component instanceof JLabel) {
                    int mode;
                    JLabel label = (JLabel)component;
                    ImageIcon icon = null;
                    if (value instanceof Integer && VWModeType.isValid(mode = ((Integer)value).intValue())) {
                        switch (mode) {
                            case 1: {
                                icon = m_readOnlyIcon;
                                label.setToolTipText(VWResource.s_readAccess);
                                break;
                            }
                            case 3: {
                                icon = m_readWriteIcon;
                                label.setToolTipText(VWResource.s_readWriteAccess);
                                break;
                            }
                            case 2: {
                                icon = m_writeOnlyIcon;
                                label.setToolTipText(VWResource.s_writeAccess);
                            }
                        }
                    }
                    label.setIcon(icon);
                }
                return component;
            }
        };
        this.m_nameRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                String tooltip = null;
                ImageIcon icon = null;
                if (component != null && component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    if (value != null && value instanceof VWParameterDefinition) {
                        VWParameterDefinition def = (VWParameterDefinition)value;
                        label.setText(def.getName());
                        int type = def.getDataType();
                        switch (type) {
                            case 32: {
                                icon = m_attachmentIcon;
                                break;
                            }
                            case 64: {
                                icon = m_workflowGroupIcon;
                                break;
                            }
                            default: {
                                icon = m_dataFieldIcon;
                            }
                        }
                        tooltip = def.getName();
                    }
                }
                if (component != null) {
                    if (tooltip != null && tooltip.length() == 0) {
                        tooltip = null;
                    }
                    if (component instanceof JLabel) {
                        ((JLabel)component).setIcon(icon);
                    }
                    ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(tooltip, 0));
                }
                return component;
            }
        };
        this.m_expressionRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                String tooltip = null;
                if (component != null && component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    if (value != null && value instanceof VWParameterDefinition) {
                        VWParameterDefinition def = (VWParameterDefinition)value;
                        label.setText(def.getValue());
                        tooltip = def.getValue();
                    }
                }
                if (component != null) {
                    ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(tooltip, 0));
                }
                return component;
            }
        };
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        try {
            this.setUpdating();
            boolean bVisible = false;
            if (this.m_operationVector != null) {
                this.m_operationVector.removeAllElements();
            }
            if (!this.bCompoundStep) {
                bVisible = !this.m_propPanel.getDataModel().isLaunchStep(this.m_stepDefinition);
                String operationName = this.m_stepDefinition.getOperationName();
                if (operationName != null && operationName.length() > 0) {
                    this.m_operationVector.addElement(operationName);
                } else {
                    this.m_operationVector.addElement(VWResource.s_noneNoBracket);
                }
            } else {
                bVisible = !this.m_propPanel.getDataModel().isLaunchStep(this.m_compoundStepDefinition);
                try {
                    VWInstructionDefinition[] instructionDefs = this.m_compoundStepDefinition.getInstructions();
                    if (instructionDefs != null) {
                        for (int i = 0; i < instructionDefs.length; ++i) {
                            if (instructionDefs[i].getAction() != 23) continue;
                            this.m_operationVector.addElement(instructionDefs[i]);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bVisible) {
                this.initOperationComboModel();
            }
            this.m_operationNameLabel.setVisible(bVisible);
            this.m_operationCombo.setVisible(bVisible);
            if (this.m_operationCombo != null && this.m_operationComboModel.getSize() > 0) {
                this.m_operationCombo.setSelectedIndex(0);
            } else {
                this.m_operationCombo.setSelectedIndex(-1);
            }
            this.initParameterModel();
        }
        finally {
            this.doneUpdating();
        }
    }

    private void initOperationComboModel() {
        if (this.m_operationCombo != null) {
            if (this.m_operationComboModel == null) {
                this.m_operationComboModel = new DefaultComboBoxModel();
                this.m_operationCombo.setModel(this.m_operationComboModel);
            } else {
                this.m_operationComboModel.removeAllElements();
            }
            for (int i = 0; i < this.m_operationVector.size(); ++i) {
                this.m_operationComboModel.addElement(this.m_operationVector.elementAt(i));
            }
            if (this.m_operationComboModel.getSize() == 0) {
                this.m_operationComboModel.addElement(VWResource.s_noneNoBracket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getParameters() {
        try {
            this.setUpdating();
            this.m_parameters = new Vector();
            VWParameterDefinition[] parameters = null;
            if (this.m_operationCombo != null && this.m_operationCombo.getSelectedIndex() >= 0) {
                Object obj = this.m_operationCombo.getSelectedItem();
                if (obj instanceof String && this.m_stepDefinition != null) {
                    parameters = this.getParameterDefinitions((String)obj, this.m_stepDefinition);
                } else if (obj instanceof VWInstructionDefinition && this.m_compoundStepDefinition != null) {
                    parameters = this.getParameterDefinitions((VWInstructionDefinition)obj, this.m_compoundStepDefinition);
                }
            }
            String thisName = null;
            String name = null;
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    Object obj;
                    void def = parameters[i];
                    if (def == null || (thisName = def.getName()) == null) continue;
                    int j = 0;
                    for (j = 0; !(j >= this.m_parameters.size() || (obj = this.m_parameters.elementAt(j)) != null && obj instanceof VWParameterDefinition && (name = ((VWParameterDefinition)obj).getName()) != null && VWStringUtils.compareIgnoreCase(thisName, name) < 0); ++j) {
                    }
                    this.m_parameters.insertElementAt(def, j);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.doneUpdating();
        }
        return this.m_parameters;
    }

    private VWParameterDefinition[] getParameterDefinitions(VWInstructionDefinition def, VWCompoundStepDefinition compoundStepDefinition) {
        VWParameterDefinition[] parameters = null;
        try {
            VWOperationDefinition vwOperationDef;
            VWQueueDefinition vwQueueDef;
            String queueName = VWInstruction.ExecuteInstructionGetQueueName(def);
            String operationName = VWInstruction.ExecuteInstructionGetOperationName(def);
            String[] parameterValues = VWInstruction.ExecuteInstructionGetParameterList(def);
            VWQueue vwQueue = VWDefaultSessionProxy.getQueue(queueName);
            if (vwQueue != null && (vwQueueDef = vwQueue.fetchQueueDefinition()) != null && (vwOperationDef = vwQueueDef.getOperation(operationName)) != null && (parameters = vwOperationDef.getParameterDefinitions()) != null) {
                for (int i = 0; i < parameters.length && i < parameterValues.length; ++i) {
                    if (parameters[i] == null || parameterValues[i] == null) continue;
                    parameters[i].setValue(parameterValues[i]);
                }
            }
        }
        catch (Exception ex) {
            parameters = null;
        }
        return parameters;
    }

    private VWParameterDefinition[] getParameterDefinitions(String operationName, VWStepDefinition stepDefinition) {
        VWParameterDefinition[] parameters;
        block8: {
            parameters = null;
            try {
                if (this.m_stepDefinition == null) break block8;
                if (operationName == null) {
                    parameters = this.m_stepDefinition.getParameterDefinitions();
                    break block8;
                }
                if (VWStringUtils.compareIgnoreCase(operationName, VWResource.s_noneNoBracket) == 0) {
                    parameters = this.m_stepDefinition.getParameterDefinitions();
                    break block8;
                }
                try {
                    VWOperationDefinition operationDef;
                    VWQueueDefinition queueDef;
                    VWQueue queue;
                    String queueName = this.m_stepDefinition.getQueueName();
                    if (queueName != null && (queue = VWDefaultSessionProxy.getQueue(queueName)) != null && (queueDef = queue.fetchQueueDefinition()) != null && (operationDef = queueDef.getOperation(operationName)) != null && (parameters = operationDef.getParameterDefinitions()) != null) {
                        String[] operationParameters = this.m_stepDefinition.getOperationParameters();
                        for (int i = 0; i < parameters.length && i < operationParameters.length; ++i) {
                            if (parameters[i] == null || operationParameters[i] == null) continue;
                            parameters[i].setValue(operationParameters[i]);
                        }
                    }
                }
                catch (Exception ex) {
                    parameters = null;
                }
            }
            catch (VWException ex) {
                // empty catch block
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initParameterModel() {
        try {
            this.setUpdating();
            if (this.m_parameterTableModel == null) {
                this.m_parameterTableModel = new VWParameterTableModel(this.getParameters());
                if (this.m_parameterTable == null) {
                    this.m_parameterTable = new VWTable(this.m_parameterTableModel);
                } else {
                    this.m_parameterTable.setModel(this.m_parameterTableModel);
                }
            } else {
                this.m_parameterTableModel.setData(this.getParameters());
                this.m_parameterTableModel.fireTableDataChanged();
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            return this.m_updatingCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            ++this.m_updatingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doneUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            if (this.m_updatingCount > 0) {
                --this.m_updatingCount;
            }
        }
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_stepDefinition = null;
        this.m_compoundStepDefinition = null;
        if (this.m_parameters != null) {
            this.m_parameters.removeAllElements();
            this.m_parameters = null;
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.removeReferences();
            this.m_parameterTable = null;
        }
        this.m_operationNameLabel = null;
        if (this.m_parameterTableModel != null) {
            this.m_parameterTableModel.removeReferences();
            this.m_parameterTableModel = null;
        }
        if (this.m_operationVector != null) {
            this.m_operationVector.removeAllElements();
            this.m_operationVector = null;
        }
        if (this.m_operationCombo != null) {
            this.m_operationCombo.removeAllItems();
            this.m_operationCombo = null;
        }
        this.m_operationComboModel = null;
        this.m_modeRenderer = null;
        this.m_nameRenderer = null;
        this.m_expressionRenderer = null;
        this.m_promptUI = null;
        this.m_countSync = null;
        this.removeAll();
    }

    private class VWParameterTableModel
    extends AbstractTableModel {
        Vector m_data = null;
        String[] m_columnNames = new String[]{"", VWResource.s_name, VWResource.s_expression};

        VWParameterTableModel() {
            this.m_data = null;
        }

        VWParameterTableModel(Vector data) {
            this.m_data = data;
        }

        public void setData(Vector data) {
            this.m_data = data;
        }

        public int getRowCount() {
            if (this.m_data != null) {
                return this.m_data.size();
            }
            return 2;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return VWParameterDefinition.class;
                }
                case 2: {
                    return VWParameterDefinition.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return null;
            }
            Object obj = this.m_data.elementAt(row);
            if (obj != null && obj instanceof VWParameterDefinition) {
                VWParameterDefinition def = (VWParameterDefinition)obj;
                switch (col) {
                    case 0: {
                        int mode = def.getMode();
                        return new Integer(mode);
                    }
                    case 1: {
                        return def;
                    }
                    case 2: {
                        return def;
                    }
                }
            }
            return null;
        }

        public void removeReferences() {
            this.m_data = null;
            if (this.m_columnNames != null) {
                for (int i = 0; i < this.m_columnNames.length; ++i) {
                    this.m_columnNames[i] = null;
                }
                this.m_columnNames = null;
            }
        }
    }
}

